//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	Merging SIH interview quarter variable
// Objective: 	Extracting the interview quarter variable from the household
//				file and matching it to the person file to allow the interviews
//				to be re-weighted so thast they are evenly distributed throughout
//				the year.
//
// Created: 	02/08/2021
// Modified: 	15/11/2021
//==============================================================================

*******************
*** 2007-08 SIH ***
*******************

clear

cd "XXXX"	// set the content directory here

use sih07bh.dta	// importing the data

keep QUARTERH ABSHID

save sih07_interview_qtr, replace

clear

use sih07bp.dta	// importing the person-level data

merge m:1 ABSHID using sih07_interview_qtr.dta, nogen

save sih07bp.dta, replace

*******************
*** 2009-10 SIH ***
*******************

clear

use sih09bh.dta	// importing the data

keep QUARTERH ABSHID

save sih09_interview_qtr, replace

clear

use sih09bp.dta	// importing the person-level data

merge m:1 ABSHID using sih09_interview_qtr.dta, nogen

save sih09bp.dta, replace

*******************
*** 2011-12 SIH ***
*******************

clear

use sih11bh.dta	// importing the data

keep QUARTERH ABSHID

save sih11_interview_qtr, replace

clear

use sih11bp.dta	// importing the person-level data

merge m:1 ABSHID using sih11_interview_qtr.dta, nogen

save sih11bp.dta, replace

*******************
*** 2013-14 SIH ***
*******************

clear

use sih13bh.dta	// importing the data

keep QUARTERH ABSHID

save sih13_interview_qtr, replace

clear

use sih13bp.dta	// importing the person-level data

merge m:1 ABSHID using sih13_interview_qtr.dta, nogen

save sih13bp.dta, replace

*******************
*** 2015-16 SIH ***
*******************

clear

use sih15bh.dta	// importing the data

keep qtritrwh abshid

save sih15_interview_qtr, replace

clear

use sih15bp.dta	// importing the person-level data

merge m:1 abshid using sih15_interview_qtr.dta, nogen

save sih15bp.dta, replace

*******************
*** 2017-18 SIH ***
*******************

clear

use sih17bh.dta	// importing the data

keep qtritrwh abshid

save sih17_interview_qtr, replace

clear

use sih17bp.dta	// importing the person-level data

merge m:1 abshid using sih17_interview_qtr.dta, nogen

save sih17bp.dta, replace
